#include "system/common/sys_common.h"
#include "app.h"
#include "system_definitions.h"


void kukan_ON(unsigned char, unsigned char);
void kukan_OFF(unsigned char);
void speed_pulse_on(unsigned char);
void speed_pulse_off();
void section_change_monitor(unsigned char); //ԕωĎ
void next_section_on(unsigned char); //Ԃnm


void timer_int_func() {
    //C^vg0-0x1ffŃJEg
    if (++int_counter > 0x1ff) {
        int_counter = 0;
    }

    switch (int_counter) {
        case 0:
            //C^vgJE^ÔƂAspeedpXON
            train_sou[0] = &train[cont_train[0]];
            speed_pulse_on(0);
            break;

        case 2:
            //C^vgJE^0x2̂ƂA̋ԕωĎ(B0x102̂Ƃ)
            section_change_monitor(0);
            break;

        case 3:
            //C^vgJE^3̂ƂNEXTԃpXON(B0x103̂Ƃ)
            //ԕωmFɎԂON
            next_section_on(0);
            break;

    }

    //Xs[hpXOFF
    speed_pulse_off();

}

void speed_pulse_on(unsigned char sou) {

    if (train_sou[sou]) {
        kukan[sou] = 0; //kukan clr

        speed_pw[sou] = train_sou[sou]->speed;

        //ԃɌEOʒűԂݒ肵ON
        if (train_sou[sou]->NOW.BIT.ROSEN == ROSEN_NUM) {
            kukan[sou] = EnableBit[train_sou[sou]->NOW.BIT.KUKAN];
            kanshi_now[sou] = train_sou[sou]->NOW.BIT.KUKAN;
        }
        if (train_sou[sou]->BEFORE.BIT.ROSEN == ROSEN_NUM) {
            kukan[sou] |= EnableBit[train_sou[sou]->BEFORE.BIT.KUKAN];
            kanshi_before[sou] = train_sou[sou]->BEFORE.BIT.KUKAN;
        }

        // Ԃnm
        kukan_ON(kukan[sou], train_sou[sou]->NOW.BIT.DIR);

    }



}

//ONp

void kukan_ON(unsigned char kukan, unsigned char d) {
    // d=0:], 1:]
    if (d == 0) {
        LATB |= kukan;
        _LATB12 = 0; //Port RB12͋ʑ
    } else {
        LATB &= ~kukan;
        _LATB12 = 1;
    }

    TRISB &= ~kukan;
    _TRISB12 = 0;

}

//OFFp

void kukan_OFF(unsigned char kukan) {
    TRISB |= kukan;
    _TRISB12 = 1;
}

void speed_pulse_off() {
    //C^vgƂspeed}CiX1ĂOɂȂpXOFF
    unsigned char n;

    for (n = 0; n < 2; n++) {

        if (train_sou[n]) {
            if (speed_pw[n] == 0) {
                //speedOŋԃpXOFF
                kukan_OFF(kukan[n]);
 
            } else {
                speed_pw[n]--; //speed}CiX1
            }
        }
    }
}

void section_change_monitor(unsigned char sou) {

    if (train_sou[sou]) {
        if (train_sou[sou]->STATUS.BIT.SAFE)
            if (!train_sou[sou]->henka) {
                if (train_sou[sou]->NEXT.BIT.ROSEN == ROSEN_NUM) {
                    //ʒuԂ̊Ď
                    kanshi.BIT.KUKAN = train_sou[sou]->NEXT.BIT.KUKAN;
                    LATA &= 0xC3;
                    LATA |= kanshi.BYTE;

                    //ADCǂݍ

                    PLIB_ADC_SamplingStart(ADC_ID_1);
                    while (!PLIB_ADC_ConversionHasCompleted(ADC_ID_1));
                    adc_ret.INT = PLIB_ADC_ResultGetByIndex(ADC_ID_1, 0);

                    if (sou == 0)debug1.INT = adc_ret.INT;

                    if (train_sou[sou]->NOW.BIT.DIR == 0) {
                        //̂Ƃ
                        if (adc_ret.BYTE.H >= 0x3) {
                            train_sou[sou]->henka = 0x80; //ԕω
                        }

                    } else {
                        //t̂Ƃ
                        if (adc_ret.BYTE.H < 0x1) {
                            train_sou[sou]->henka = 0x80; //ԕω
                        }
                    }

                }
            }
    }

}

void next_section_on(unsigned char sou) {
    //ԂON
    if (train_sou[sou]) {
        if (train_sou[sou]->STATUS.BIT.SAFE) {
            //SłȂƂ͎Ԃɑ̗ԂĂ̂ONȂB
            if (train_sou[sou]->NEXT.BIT.ROSEN == ROSEN_NUM)
                kukan[sou] |= EnableBit[train_sou[sou]->NEXT.BIT.KUKAN];

            kukan_ON(kukan[sou], train_sou[sou]->NOW.BIT.DIR);
        }

    }
}






/* *****************************************************************************
 End of File
 */
